function [dist_degrees, dist_mm, dist_pix, centerBubble] = findErrorBubble(imgName, length_mm, deg_from_zero, mm_from_zero, saveName)
	img = imread(imgName); 
	%figure; imshow(img); 
	imgr = imcomplement(img);
	[h, w] = size(imgr);
	w2 = ceil(w/2); 
	h2 = ceil(h/5); 
	
	info = regionprops(imgr, {'Centroid', 'Orientation'});
	centroids = cat(1, info.Centroid);
	c2 = find(centroids(:,2)>20); 	%save only the ones that have center at least fifth of height
	centroids = centroids(c2,:); 
	orientation = cat(1, info.Orientation); 
	orientation = orientation(c2, :);	
	
	[nrOff,index] = min(abs(w2-centroids(:,1))); 
	centerBubble = [centroids(index, 1), centroids(index, 2)]; 
	dist_pix = centroids(index,1) - w2; 
	factor = length_mm/w; 
	dist_mm = round(dist_pix * factor, 3); 
	dist_degrees = round((dist_mm / mm_from_zero) * deg_from_zero, 3); 
	
	xs = [1:w]; 
	ys_h = (sind(orientation(index))*-(xs-centroids(index,1)))+centroids(index,2); 
	
	
	
	figure('visible', 'off'); 
	imshow(imgr); 
	truesize([h*2 w*2]);
	hold on
	
	%centers
	plot(centroids(index,1), centroids(index,2), 'wo'); 
	plot(w2, centroids(index,2), 'go'); 
	,
	
	%direction of the bubble
	line(xs, ys_h, 'color', 'r', 'lineWidth', 1.5);
	
	%
	xline(centroids(index,1),'-.r', 'lineWidth', 1.5); 
	yline(centroids(index,2),'-.g', 'lineWidth', 1.5); 
	%true center vertical line
	xline(w2,'-.g', 'lineWidth', 1.5); 
	bot = 0.7; 
	
	quiver(w2, h*bot, (centroids(index,1) - w2), 0, 0, 'MaxHeadSize', 1, 'Color', 'g', 'LineWidth', 2); 
	if(w2 > centroids(index,1))
		text(w2, h*bot, {'Error:', strcat(num2str(dist_mm), 'mm'), strcat(num2str(dist_degrees), char(176))}, 'FontSize', 14, 'FontWeight', 'bold', 'Color', 'red', 'HorizontalAlignment', 'left');
	else
		text(w2, h*bot, {'Error:', strcat(num2str(dist_mm), 'mm'), strcat(num2str(dist_degrees), char(176))}, 'FontSize', 14, 'FontWeight', 'bold', 'Color', 'red', 'HorizontalAlignment', 'right');
	end
	hold off
	
	
	F = getframe(gcf);
	img_error = F.cdata; 
	imwrite(img_error, saveName);
	
	close(figure);
end